<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */
 
!defined('DL_Root') && exit ( 'Access Denied!' );

class DDbBase extends DuoLamBase{

	private static $_db;

	private static $_cache;

	private $_querynum;

	protected $_result_;

	public function __construct()
	{
		try
		{
			self::$_cache = DuoLam::app(DuoLam::$config['cache']['driver']);
			self::$_db = new PDO(DuoLam::$config['db']['driver'].':host='.Duolam::$config['db']['host'].';port='.DuoLam::$config['db']['port'].';dbname='.Duolam::$config['db']['dbname'], DuoLam::$config['db']['user'], DuoLam::$config['db']['pw'],array( PDO::ATTR_PERSISTENT => DuoLam::$config['db']['p']));
			$this->exec('SET NAMES '.DuoLam::$config['db']['dbcharset']);
		}
		catch(PDOException $e)
		{
			DEr::notice('连接不到 '.DuoLam::$config['db']['driver'].' 服务器或数据库 '.$e->getMessage(),'');
		}
	}

	protected function exec($sql)
	{
		$this->_querynum++;
		$sql = self::setTableSuffix($sql);
		$info = self::$_db->exec($sql);
		if($info === false or $info === null) self::error('SQL语句执行错误！',$sql);
		return $info;
	}

	protected function query($sql)
	{
		$sql = self::setTableSuffix($sql);
		$this->_result_ = self::$_db->query($sql) or self::error('SQL查询出错',$sql);
		$this->_querynum++;
	}

	protected function _fetch($sql,$type=0,$cacheTime=0,$mode=PDO::FETCH_ASSOC)
	{
		if($cacheTime > 0)
		{
			$value = ($type==0) ? self::$_cache->get($sql) : ($type==1) ? self::$_cache->get($sql,true) : null;
			if($value === false)
			{
				$this->query($sql);
				$this->_result_->setFetchMode($mode);
				if($type==0)
				{
					$value = $this -> _result_ -> fetch();
					self::$_cache -> set($sql,$value,$cacheTime);
				}
				else if($type==1)
				{
					$value = $this -> _result_ -> fetchAll();
					self::$_cache -> set($sql,$value,$cacheTime,true);
				}
			}
			return $value;
		}
		else if($cacheTime == 0)
		{
			$this->query($sql);
			$this->_result_->setFetchMode($mode);
			if($type==0)
			{
				return $this->_result_->fetch();
			}
			else if($type==1)
			{
				return $this->_result_->fetchAll();
			}
		}
	}
	
	protected function _update($params)
	{
		$upfield ='';
		foreach($params['field'] as $k => $v) $upfield .= "`$k`='$v',";
		$upfield = substr($upfield,0,-1);
		return $this->exec("UPDATE ".$params['table']." SET $upfield WHERE ".$params['where']);
	}

	protected function _insert($params)
	{
		$field = $value = null;
		foreach($params['field'] as $k => $v)
		{
			$field .= ",`$k`";
			$value .= ",'$v'";
		}
		$field = substr($field,1);$value = substr($value,1);
		$this->exec("INSERT INTO ".$params['table']."($field) VALUES($value)");
		return $this->lastId();
	}

	protected function _delete($params)
	{
		return $this->exec('DELETE FROM '.$params['table'].' WHERE '.$params['where']);
	}

	public function sqlCount($sql)
	{
		$this->query($sql);
		return $this->_result_->fetch(PDO::FETCH_COLUMN);
	}

	public function rowCount($sql)
	{
		$this->query($sql);
		return count($this->_result_->fetchAll(PDO::FETCH_ASSOC));
	}

	public function autocommit()
	{
		self::$_db->beginTransaction();
	}

	public function commit()
	{
		self::$_db->commit();
	}

	public function rollback()
	{
		self::$_db->rollback();
	}

	public function getQueryNum()
	{
		return $this->_querynum;
	}

	public function lastId()
	{
		return self::$_db->lastInsertId();
	}

	protected static function setTableSuffix($sql)
	{
		return preg_replace('/{{(.*?)}}/i',DuoLam::$config['db']['pre'].'\\1',$sql);
	}

	protected static function error($mess,$sql)
	{
		$params = array(
			'sql' => $sql,
			'errorInfo'=>self::$_db->errorInfo(),
			'errorCode'=>self::$_db->errorCode()
		);
		DEr::error($mess,true,$params);
	}

	private function close()
	{
		$this->_result_=null;
		self::$_db=null;
	}

	protected function returnDb()
	{
		return self::$_db;
	}

	protected function returnCache()
	{
		return self::$_cache;	
	}

	public function __destruct()
	{
		$this->close();
	}
}
?>